import { c as createComponent, f as createAstro, m as maybeRenderHead, b as renderComponent, r as renderTemplate, F as Fragment, u as unescapeHTML } from './astro/server_CQVWm2UQ.mjs';
import 'kleur/colors';
import { $ as $$Image } from './_astro_assets_DhhuFP3V.mjs';
import { $ as $$ProgramCard } from './ProgramCard_DNVBF53N.mjs';

const $$Astro = createAstro();
const $$ProgramDetails = createComponent(async ($$result, $$props, $$slots) => {
  const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
  Astro2.self = $$ProgramDetails;
  const PROGRAM_RESPONSE = await fetch(
    "https://admin.iba-ju.edu.bd/api/admin/program-sections/by-program-id/" + Astro2.props.id
  );
  const PROGRAM_DATA = await PROGRAM_RESPONSE.json();
  const PROGRAM_SECTIONS = PROGRAM_DATA.data;
  return renderTemplate`${maybeRenderHead()}<div class="container-fluid"> <div class="row"> <div class="col-lg-12"> <div class="program-details-left-sidebar"> <div class="program"> ${PROGRAM_SECTIONS.map((section, i) => renderTemplate`${renderComponent($$result, "ProgramCard", $$ProgramCard, { "title": section.section_name, "inverse": i % 2 === 0 }, { "content--image": async ($$result2) => renderTemplate`${renderComponent($$result2, "Image", $$Image, { "src": section.section_content.content_image, "alt": section.section_name + "_image", "slot": "content--image", "inferSize": true })}`, "content--text": async ($$result2) => renderTemplate`${renderComponent($$result2, "Fragment", Fragment, { "slot": "content--text" }, { "default": async ($$result3) => renderTemplate`${unescapeHTML(section.section_content.content_text)}` })}` })}`)} </div> </div> </div> </div> </div>`;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/ProgramDetails.astro", void 0);
const $$file = "E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/ProgramDetails.astro";
const $$url = void 0;

export { $$ProgramDetails as default, $$file as file, $$url as url };
