import { c as createComponent, r as renderTemplate, m as maybeRenderHead, f as addAttribute, e as createAstro } from './astro/server_FQnuC0tz.mjs';
import 'kleur/colors';
import 'clsx';
/* empty css                             */

const $$Astro = createAstro();
const $$Curriculum = createComponent(async ($$result, $$props, $$slots) => {
  const Astro2 = $$result.createAstro($$Astro, $$props, $$slots);
  Astro2.self = $$Curriculum;
  const PROGRAM_COURSE_RESPONSE = await fetch(
    "https://admin.iba-ju.edu.bd/api/admin/course/by-program-id/" + Astro2.props.program_id
  );
  const PROGRAM_COURSE_DATA = await PROGRAM_COURSE_RESPONSE.json();
  const PROGRAM_COURSE = PROGRAM_COURSE_DATA.data;
  return renderTemplate`${maybeRenderHead()}<section class="curriculum-content" data-astro-cid-nvvdbdcv> <header data-astro-cid-nvvdbdcv><h2 class="pb-40" data-astro-cid-nvvdbdcv>Carriculum</h2></header> <div class="accordion" id="accordionExample" data-astro-cid-nvvdbdcv> ${PROGRAM_COURSE.map((semester, index) => {
    const semester_name = Object.keys(semester)[0];
    return renderTemplate`<div class="accordion-item" data-astro-cid-nvvdbdcv> <h2 class="accordion-header" id="headingOne" data-astro-cid-nvvdbdcv> <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${addAttribute("#semester" + index, "data-bs-target")} aria-expanded="false" aria-controls="collapseOne" data-astro-cid-nvvdbdcv> <span data-astro-cid-nvvdbdcv>${semester_name}</span> </button> </h2> <div${addAttribute("semester" + index, "id")} class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample" data-astro-cid-nvvdbdcv> <div class="accordion-body" data-astro-cid-nvvdbdcv> <table class="table table-bordered" data-astro-cid-nvvdbdcv> <tr data-astro-cid-nvvdbdcv> <th data-astro-cid-nvvdbdcv>Course ID</th> <th data-astro-cid-nvvdbdcv>Course Name</th>  </tr> ${semester[semester_name].map((course) => renderTemplate`<tr data-astro-cid-nvvdbdcv> <td data-astro-cid-nvvdbdcv>${course.course_id}</td> <td data-astro-cid-nvvdbdcv>${course.course_name}</td> </tr>`)} </table> </div> </div> </div>`;
  })} </div> </section> `;
}, "E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/Curriculum.astro", undefined);
const $$file = "E:/abir-vai/Ju-iba/ju-IBA/src/components/programs/Curriculum.astro";
const $$url = undefined;

export { $$Curriculum as default, $$file as file, $$url as url };
